
import os
from ament_index_python.packages import get_package_share_directory
from launch import LaunchDescription
from launch_ros.actions import Node
from launch.actions import ExecuteProcess

def generate_launch_description():
    # 启动一个ROS2节点
    # my_node = Node(
    #     package='my_package',  # 替换为你的包名
    #     executable='my_node',   # 替换为你的节点可执行文件名
    #     name='my_node',         # 节点名称
    #     output='screen'         # 输出到终端
    # )

    # 启动rviz2
    # rviz2 = ExecuteProcess(
    #     cmd=['rviz2', '-d', '/path/to/your/config.rviz'],         # 启动rviz2
    #     output='screen'         # 输出到终端
    # )

    package_share_dir = get_package_share_directory('stereo4')
    calib_file = os.path.join(package_share_dir, 'config/calib', 'baton_ds_168.yaml')
    yaml_file = os.path.join(package_share_dir, 'config', 'sys_baton.yaml')
    csv_file = os.path.join(package_share_dir, '../../../Log', 'diff_pose.csv')
    vio_params_file = os.path.join(package_share_dir, 'config', 'vio_stereo_baton_ros2.yaml')

    stereo4 = Node(
        package='stereo4',  # 包名
        executable='stereo4',   # 节点可执行文件名
        name='stereo4',         # 节点名称
        output='screen',         # 输出到终端
        parameters=[
            vio_params_file,  # 直接加载VIO参数文件
            {
                'sys_yaml_file': yaml_file,
                'diff_pose_path' : csv_file,
                'calib_file': calib_file,
                'cam0_topic': '/baton/image_left',
                'cam1_topic': '/baton/image_right',
                'imu_topic': '/baton/imu',
            }
        ],
    )

    rviz_config = os.path.join('install', 'stereo4', 'share', 'stereo4', 'config', 'stereo4_ros2_indoor.rviz')
    rviz2 = Node(
        package='rviz2',
        executable='rviz2',
        name='rviz2',
        arguments=['-d', rviz_config]
    )

    return LaunchDescription([
        stereo4,
        rviz2
    ])


'''
import os
from ament_index_python.packages import get_package_share_directory
from launch import LaunchDescription
from launch_ros.actions import Node

def generate_launch_description():
    # 获取包的安装路径
    package_share_dir = get_package_share_directory('my_package')
    
    # 1. 使用ament_index_python获取包路径
    # 拼接配置文件的相对路径
    rviz_config = os.path.join(package_share_dir, 'rviz', 'my_config.rviz')

    # 2. 使用相对路径：
    # 如果配置文件位于install目录下，可以直接使用相对路径。例如，假设配置文件在install/my_package/share/my_package/rviz/my_config.rviz，可以通过以下方式拼接路径：
    rviz_config = os.path.join('install', 'my_package', 'share', 'my_package', 'rviz', 'my_config.rviz')
    return LaunchDescription([
        Node(
            package='rviz2',
            executable='rviz2',
            name='rviz2',
            arguments=['-d', rviz_config]
        )
    ])
'''    