#include <stdio.h>
#include <string.h>

// Berxel Head File
#include "BerxelHawkContext.h"
#include "BerxelHawkDevice.h"
#include "BerxelHawkFrame.h"
#include "BerxelHawkDefines.h"
#include "BerxelCommonFunc.h"
#include "BerxelImageRender.h"
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
berxel::BerxelHawkContext*   g_context = NULL;
berxel::BerxelHawkDevice*    g_pHawkDevice = NULL;
berxel::BerxelHawkDeviceInfo g_CurrentDeviceInfo;
BerxelImageRender*			 g_pImageRender = NULL;

static int  g_imageWidth = 640;
static int  g_imageHeight = 400;
static char g_errMsg[256] = {0};
static char g_deviceShowInfo[256];
static bool g_bStartStream = false;
static bool g_bSave = false;

static bool renderImage()
{	
	static char              mesgInfo[256] = {0};
	static RGB888	         rgbImage[1920 * 1080];
	berxel::BerxelHawkFrame* pHawkFrame = NULL;

	if(false == g_bStartStream)
	{
		g_pImageRender->initView();
		g_pImageRender->drawLine(0,35, g_imageWidth + 80 ,40);
		g_pImageRender->drawString(g_errMsg, 5, 25 , (void *)0x0008);
		g_pImageRender->drawLine(0,g_imageHeight + 42, g_imageWidth + 80 ,40);
		g_pImageRender->updateView();	
		return false;
	}

	if(g_pHawkDevice)
	{
		int ret = g_pHawkDevice->readColorFrame(pHawkFrame,30);
	}		
	if(pHawkFrame == NULL)
	{
		return false;
	}
	//memcpy(rgbImage, pHawkFrame->getData(),pHawkFrame->getDataSize());
	cv::Mat yuv(pHawkFrame->getHeight(), pHawkFrame->getWidth(), CV_8UC2, pHawkFrame->getData());
	cv::Mat img;
	cv::cvtColor(yuv, img, cv::COLOR_YUV2RGB_UYVY);
	memcpy(rgbImage, img.ptr<unsigned char>(0), pHawkFrame->getWidth() * pHawkFrame->getHeight() * 3);
	static int index = 0;
	if(g_bSave)
	{
		index ++;
		BerxelCommonFunc::getInstance()->saveRawData((uint8_t*)pHawkFrame->getData(),  pHawkFrame->getDataSize(), "Color", index);
		BerxelCommonFunc::getInstance()->takePhoto("Color",index ,(uint8_t *)rgbImage, pHawkFrame->getWidth(), pHawkFrame->getHeight());
		g_bSave = false;
	}

	 memset(mesgInfo ,0 ,sizeof(mesgInfo));
	 sprintf(mesgInfo , "%d*%d@fps %d" ,pHawkFrame->getWidth() , pHawkFrame->getHeight() ,pHawkFrame->getFPS());

	//Render Image
	g_pImageRender->initView();
	g_pImageRender->drawLine(0,35, g_imageWidth + 80 ,40);
	g_pImageRender->drawString(mesgInfo,5,25 , (void *)0x0008);
	g_pImageRender->drawLine(0,g_imageHeight + 42, g_imageWidth + 80 ,40);
	g_pImageRender->drawString(g_deviceShowInfo, 5, g_imageHeight + 40 + 25 , (void *)0x0007);
	WinRect rect(40, 40, g_imageWidth, g_imageHeight);
	g_pImageRender->drawColorImage((uint8_t*)rgbImage,pHawkFrame->getWidth(), pHawkFrame->getHeight(),  rect);
	g_pImageRender->updateView();
	
	// free frame
	g_pHawkDevice->releaseFrame(pHawkFrame);			
    return true;
}


void keyCallBack(unsigned char key)
{
	switch (key)
	{
	case 'S':
	case 's':
	{
		g_bSave = true;
	}
	break;
	case 'K':
	case 'k':
		{
			uint32_t logSize = 0;
			g_pHawkDevice->getDeviceLogSize(&logSize);
			printf("Device log size : %u\n", logSize);

			if (logSize == 0) {
				printf("Get device log error, log size is zero.\n");
				break;
			}

			char* logData = (char*)malloc(logSize);
			int32_t ret = g_pHawkDevice->getDeviceLog(logData, logSize);
			if (ret != 0) {
				printf("Get device error : %d\n", ret);
				free(logData);
				logData = NULL;
				break;
			}

			FILE* fp = fopen("berxel_camera.log.gz", "wb");
			if (fp != NULL)
			{
				fwrite(logData, logSize, 1, fp);
				fclose(fp);
			}
			free(logData);
			logData = NULL;
		}
		break;
	default:
		printf("Please input 's' or 'S'  to save image: \n");
		break;
	}
}

int Exit()
{
	if(g_pHawkDevice)
	{
		g_pHawkDevice->stopStreams(berxel::BERXEL_HAWK_COLOR_STREAM);
	}

	if(g_context)
	{
		g_context->closeDevice(g_pHawkDevice);
	}

	if(g_context)
	{
        berxel::BerxelHawkContext::destroyBerxelContext(g_context);
		g_context = NULL;
	}

	return 0;
}

int creatWindow(int argc, char** argv)
{
	g_pImageRender = new BerxelImageRender(argc, argv, "Berxel HawkColor", g_imageWidth+ 80 , g_imageHeight + 80); // window title & size
	g_pImageRender->setInfoCallback(renderImage , keyCallBack);
	g_pImageRender->startView();
	return 0;
}

int main(int argc, char** argv)
{
	g_context = berxel::BerxelHawkContext::getBerxelContext();
	g_context->setGmslI2CStats(true);
	g_context->setGmslI2CAddress("/dev/i2c-2");
	berxel::BerxelHawkGmslDeviceInfo* pGmslDeviceInfo = NULL;
	uint32_t gmslDeviceCount = 0;
	g_context->getDeviceList(&pGmslDeviceInfo, &gmslDeviceCount);
	if((gmslDeviceCount <= 0) || (NULL == pGmslDeviceInfo))
	{
			sprintf(g_errMsg,"%s", "Get No Connected BerxelDevice");
			return creatWindow(argc ,argv);
	}

	for (int i = 0; i < gmslDeviceCount; i++)
	{
		printf("#####################################\n");
		printf("gmsl device name : %s\n", pGmslDeviceInfo[i].deviceAddress);
		printf("gmsl device type : %s\n", pGmslDeviceInfo[i].deviceType);
		printf("gmsl device sn : %s\n", pGmslDeviceInfo[i].serialNumber);
	}

	printf("#####################################\n");
	g_pHawkDevice = g_context->openDevice(pGmslDeviceInfo[0]);
  	if(NULL == g_pHawkDevice)
	{
		sprintf(g_errMsg,"%s", "Open Berxel Device Failed");
    		return creatWindow(argc ,argv);
  	}

	g_pHawkDevice->setSonixSlaveStatus(true);
	g_pHawkDevice->setSystemClock();
	g_pHawkDevice->setStreamFlagMode(berxel::BERXEL_HAWK_SINGULAR_STREAM_FLAG_MODE);
  	berxel::BerxelHawkStreamFrameMode frameMode;
	g_pHawkDevice->getCurrentFrameMode(berxel::BERXEL_HAWK_COLOR_STREAM ,&frameMode);
	g_pHawkDevice->setFrameMode(berxel::BERXEL_HAWK_COLOR_STREAM, &frameMode);

	// 
	int ret = g_pHawkDevice->startStreams(berxel::BERXEL_HAWK_COLOR_STREAM);
	if(ret != 0)
	{
		sprintf(g_errMsg,"%s", "Open Berxel Stream Failed");
		return creatWindow(argc ,argv);
	}
	g_bStartStream = true;

	berxel::BerxelHawkDeviceInfo tempCurInfo;
	berxel::BerxelHawkVersions   tempVersions;
	g_pHawkDevice->getCurrentDeviceInfo(&tempCurInfo);
	g_pHawkDevice->getVersion(&tempVersions);
	if (g_CurrentDeviceInfo.productId == 0x1012 && g_CurrentDeviceInfo.vendorId == 0x3558) {
		sprintf(g_deviceShowInfo, "SN :%s  SDK(%d.%d.%d) FW(%d.%d.%d-%s-%d-%d-%d) HW(%d.%d.%d) ", tempCurInfo.serialNumber, tempVersions.sdkVersion.major, tempVersions.sdkVersion.minor, tempVersions.sdkVersion.revision,
			tempVersions.fwVersion.major, tempVersions.fwVersion.minor, tempVersions.fwVersion.revision, tempVersions.fwVersion.chipVersion, tempVersions.fwVersion.subVersion.major, tempVersions.fwVersion.subVersion.minor, tempVersions.fwVersion.subVersion.revision, tempVersions.hwVersion.major, tempVersions.hwVersion.minor, tempVersions.hwVersion.revision);

	}
	else {
		sprintf(g_deviceShowInfo, "SN :%s  SDK(%d.%d.%d) FW(%d.%d.%d-%s) HW(%d.%d.%d) ", tempCurInfo.serialNumber, tempVersions.sdkVersion.major, tempVersions.sdkVersion.minor, tempVersions.sdkVersion.revision,
			tempVersions.fwVersion.major, tempVersions.fwVersion.minor, tempVersions.fwVersion.revision, tempVersions.fwVersion.chipVersion, tempVersions.hwVersion.major, tempVersions.hwVersion.minor, tempVersions.hwVersion.revision);
	}
	creatWindow(argc,argv);

	return Exit();
}
